<?php
if (!defined('_VIS_'))
    die('Error: Call from undefined function');
class forums
{
    var $error;
    // forum view function started here
    function view_forum($operation, $area = 0) // main page
    {
        global $vis_language;
        $operation['view_title']    = $vis_language['TXTFORUMS'];
        $operation['vis_filter_id'] = 1;
        $this->forum_filter($operation);
        //include(VIS_PATH_TEMPLATE.'forums_view.php');
    }
    
    //function for add forum category form 
    function add_forum_category_form($operation)
    {
        global $vis_language;
        $operation['view_title'] = $vis_language['TXTFORUMS'];
        $database                = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $object = new class_ticket($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
        $sett_object = new class_setting($database);
        
        $domain_details = $object->get_domain(VIS_TABLE_PREFIX . 'domain.is_enabled=1 ', VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($language_info, $language_details) = $sett_object->get_language('is_custom=1 and is_enabled=1', '', 0, 0, VIS_STAFF_ID, VIS_LOCATION_AREA);
        include(VIS_PATH_TEMPLATE . 'forums_category_form.php');
    }
    
    //add forum category function 
    function add_forum_category($operation)
    {
        global $vis_language;
        
        if (isset($operation['vis_action']))
            $data = parse_form_array($operation['vis_action']);
        else
            $data = $operation;
        if (trim($data['vis_cat_title']) == '') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGINFOMISS'] . '");</script>';
            return false;
        }
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forumObject = new class_forum($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'subsetting.php');
        $sub_object = new class_subsetting($database);
        $data['vis_description'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_description']);
        $result     = $forumObject->add_category($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if (!$result) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); </script>';
            return false;
        } else {
            $activity_log = $sub_object->add_staff_activity_log("New forum category added - " . $data['vis_cat_title'], VIS_STAFF_ID,9,VIS_LOCATION_AREA);
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " ' . $vis_language['MSGSUCCOPRT'] . '");$("#vis_workpanel_div").visExecution("load_module","' . $vis_language['TXTALLCATEGORY'] . '",{"vis_module":"forums", "vis_operation":"get_all_categories",});$("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"forums"}); $(".modal").modal("hide");</script>';
        }
        $database->database_disconnect();
        return true;
    }
    //function for add forum form 
    function add_forum_form($operation)
    {
        global $vis_language;
        $operation['view_title'] = $vis_language['TXTFORUMS'];
        $database                = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forum_object = new class_forum($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
        $object = new class_setting($database);
        
        $domain_details = $forum_object->get_forum_category_domain_list(VIS_TABLE_PREFIX . 'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        
        $domain_id              = (isset($operation['vis_domain_id']) && is_numeric($operation['vis_domain_id'])) ? $operation['vis_domain_id'] : ((isset($operation['vis_domain']) && is_numeric($operation['vis_domain'])) ? $operation['vis_domain'] : $domain_details[0]['domain_id']);
		
        $forum_category_details = $forum_object->get_forum_category('domain_id=' . $domain_id, VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($language_info, $language_details) = $object->get_language('is_custom=1 and is_enabled=1', '', 0, 0, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if (isset($operation['vis_domain_id']) && $operation['vis_domain_id'] != '') {
            $data_live_search = (count($forum_category_details)>10)?' data-live-search=\"true\"':'';
            $select      = "<select name=\"vis_forum_category\" class=\"form-control input-sm selectpicker\" id=\"vis_forum_category_new\" ".$data_live_search.">";
            $paging_list = '';
            for ($i = 0; $i < count($forum_category_details); $i++)
                $select .= '<option value="' . $forum_category_details[$i]['forum_cat_id'] . '" >' . $forum_category_details[$i]['category_name'] . '</option>';
            $select .= "</select>";
            echo $select;
        } else
            include(VIS_PATH_TEMPLATE . 'add_forum_form.php');
    }
    
    //add forum function 
    function new_forum($operation)
    {
        global $vis_language;
        $data = parse_form_array($operation['vis_action']);
        if ($data['vis_forum_title'] == '') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGREQFLDTIT'] . '"); </script>';
            return false;
        }
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forum_object = new class_forum($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'subsetting.php');
        $sub_object = new class_subsetting($database);
        $data['vis_forum_post_area'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_forum_post_area']);
        $ret        = $forum_object->add_new_forum($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if (!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); </script>';
            return false;
        } else {
            $activity_log = $sub_object->add_staff_activity_log("New forum added - " . $data['vis_forum_title'], VIS_STAFF_ID,9,VIS_LOCATION_AREA);
            $forum_category_details = $forum_object->get_forum_category_list('domain_id=' . $data['vis_domain'].' and '.VIS_TABLE_PREFIX.'forum_category.forum_cat_id='.$data['vis_forum_category'], VIS_STAFF_ID, VIS_LOCATION_AREA);
            $cat=addslashes($forum_category_details[0]['category_name']);
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " ' . $vis_language['MSGSUCCOPRT'] . '"); $("#vis_workpanel_div").visExecution("load_module","'.$cat.'/'.$forum_category_details[0]['forum_cat_id'].'",{"vis_module":"forums", "vis_operation":"forum_list","vis_action":"#/forums/forum_list/'.$cat.'/'.$forum_category_details[0]['forum_cat_id'].'"}); $("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"forums"}); $(".modal").modal("hide");</script>';
        }
        $database->database_disconnect();
        return true;
    }
    
    //function for add forum topic form  
    function add_forum_topic($operation)
    {
        global $vis_language;
        $operation['view_title'] = $vis_language['TXTFORUMS'];
        $header_title            = $vis_language['TXTADDTOPIC'];
        $spliter                 = (strstr($operation['vis_action'], '/')) ? '/' : ',';
        $action                  = explode($spliter, $operation['vis_action']);
       
        $forumId = (isset($action[4]))?$action[4]:'';
        $database                = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forum_object   = new class_forum($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
        $staff_object   = new class_staff($database);
		 include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'client.php');
		 $client_object=new class_client($database);
        $domain_details = $forum_object->get_forum_category_domain_list(VIS_TABLE_PREFIX . 'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $domain_id      = (isset($operation['vis_domain_id']) && is_numeric($operation['vis_domain_id'])) ? $operation['vis_domain_id'] : $domain_details[0]['domain_id'];
        if (isset($operation['vis_domain']) && is_numeric($operation['vis_domain']))
            $domain_id = $operation['vis_domain'];
		
        $forum_category_details = $forum_object->get_forum_category_list('domain_id=' . $domain_id, VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		if(isset($operation['showforum']) && $operation['showforum']=='1')
		{
			 $forum_category_id      = (isset($operation['vis_forum_category_id']) && is_numeric($operation['vis_forum_category_id'])) ? $operation['vis_forum_category_id'] : '0';
		}
		else
		{ 
	$forum_category_id      = (isset($operation['vis_forum_category_id']) && is_numeric($operation['vis_forum_category_id'])) ? $operation['vis_forum_category_id'] : $forum_category_details[0]['forum_cat_id'];
		}
      
		 if(isset($operation['vis_forum_id']) ||$operation['vis_forum_id']!='')
			 $filter = VIS_TABLE_PREFIX . 'forum.forum_cat_id=' . $operation['vis_category'].' and '.VIS_TABLE_PREFIX.'forum.forum_id='.$operation['vis_forum_id'];
		 else $filter = VIS_TABLE_PREFIX . 'forum.forum_cat_id=' . $forum_category_id;
		 
        $forum_details          = $forum_object->get_forum($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $signaturedata=$staff_object->get_signature('staff_id='.VIS_STAFF_ID.' and department_id='.$domain_id.' and is_forum=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        if($signaturedata!=-1) $signature=$signaturedata[0]['content'];
          if (defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR != 1) { 
		  $signature = get_plain_text('<br /><br />'.$signature);
	    }
	    else $signature = '<br /><br />'.$signature;
        if (VIS_LOCATION_AREA == 1) {
			$breadcrumb['Home'] = 'index.php'; 			
			list($client_info, $client_forum_signature)=$client_object->get_client('client_id='.VIS_CLIENT_ID,'',0,'',0,1);
			if($client_forum_signature!=-1) $signature=$client_forum_signature[0]['forum_signature_content'];
			if (defined('VIS_HEAD_MENU_HTML_EDITOR') && VIS_HEAD_MENU_HTML_EDITOR != 1) { 
				  $signature = get_plain_text('<br /><br />'.$signature);
			}
			else $signature = '<br /><br />'.$signature;
			if((IS_LOGIN==0 && VIS_DEFAULT_HOME_MODULE != $operation['vis_module']) || (IS_LOGIN==1 && VIS_DEFAULT_HOME_MODULE_AFTER_LOGIN != $operation['vis_module']))  $breadcrumb[$vis_language['TXTFORUMS']] = '?/forums/forums'; 
            $breadcrumb[$vis_language['TXTADDTOPIC']] = ''; 
            $vis_title = $vis_language['TXTFORUMS'];
			
            $forum_category = $forum_object->get_forum_category_list('domain_id=' . VIS_DOMAIN . ' and ' . VIS_TABLE_PREFIX . 'forum.topic_access=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
            
            for ($i = 0; $i < count($forum_category); $i++) {
                $forum        = $forum_object->get_forum(VIS_TABLE_PREFIX . 'forum.forum_cat_id=' . $forum_category[$i]['forum_cat_id'] . ' and ' . VIS_TABLE_PREFIX . 'forum.topic_access=1', -1, true, VIS_DOMAIN, VIS_LOCATION_AREA);
                $forum_list[] = $forum;
            }
            if (!defined('IS_WHMCS'))
                include(VIS_PATH_TEMPLATE . 'header.php');
            else
                echo '<link href="' . VIS_PATH_STYLE . 'vis_style.css" rel="stylesheet" />';
            if (IS_LOGIN == 1)
                include(VIS_PATH_TEMPLATE . 'forum_new_topic.php');
            else
                include(VIS_PATH_TEMPLATE . 'login.php');
            if (!defined('IS_WHMCS'))
                include(VIS_PATH_TEMPLATE . 'footer.php');
            break;
        }
        if (isset($operation['vis_domain_id']) && $operation['vis_domain_id'] != '') {
            //$data_live_search = echo (count($forum_category_details)>10)?' data-live-search="true"':'';
            $select      = "<select name=\"vis_forum_category\" id=\"vis_forum_category_new\" class=\"form-control input-sm selectpicker\" onchange=\"on_category_change($(this).val());\">";
            $paging_list = '';
            for ($i = 0; $i < count($forum_category_details); $i++)
                $select .= '<option value="' . $forum_category_details[$i]['forum_cat_id'] . '" >' . $forum_category_details[$i]['category_name'] . '</option>';
            $select .= "</select>";
            echo $select;
        } else if (isset($operation['vis_forum_category_id'])) {
            //$data_live_search = echo (count($forum_category_details)>10)?' data-live-search="true"':'';
            $select      = "<select name=\"vis_forum\" id=\"vis_forum_new\" class=\"form-control input-sm selectpicker\" >";
            $paging_list = '';
            for ($i = 0; $i < count($forum_details); $i++)
                $select .= '<option value="' . $forum_details[$i]['forum_id'] . '" >' . $forum_details[$i]['forum_title'] . '</option>';
            $select .= "</select>";
            echo $select;
        }
		else
		{
			include(VIS_PATH_TEMPLATE . 'add_forum_topics.php');
		}
    }
    
    //add forum topic function 
    function new_forum_topic($operation)
    {
        global $vis_language;
        $data = parse_form_array($operation['vis_action']);
        if (!isset($data['vis_forum_title']) || trim($data['vis_forum_title'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGREQFLDTIT'] . '"); </script>';
            return false;
        }
        if(!isset($data['vis_forum_topic_post_area']) || trim(strip_tags($data['vis_forum_topic_post_area'],"<img>")) == '') {
			 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGREQFLDDESC'] . '"); </script>';
            return false;
           
        }
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forum_object = new class_forum($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'subsetting.php');
        $sub_object = new class_subsetting($database);
        if (defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR != 1) 
        $data['vis_forum_topic_post_area'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_forum_topic_post_area']);
        $ret        = $forum_object->add_new_forum_topic($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if (!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); </script>';
            return false;
        } else {
            $data['vis_operation'] = 'new_forum_topic';
            $data['vis_topic_id']  = $ret;
            global $operation_hnd;
            $operation_hnd->check_automation($data, $database);
            $staff_activity_log = $sub_object->add_staff_activity_log("New forum topic added - " . $data['vis_forum_title'], VIS_STAFF_ID,9,VIS_LOCATION_AREA);
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " ' . $vis_language['MSGSUCCOPRT'] . '"); $("#vis_workpanel_div").visExecution("load_module","All activity/1",{"vis_module":"forums", "vis_operation":"forum_filter" , "vis_action":"#/forums/forum_filter/All activity/1"}); $("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"forums"}); </script>';
        }
        $database->database_disconnect();
        return true;
    }
    
    //get topic list function - start
    function get_topic_list($operation)
    {
        global $vis_language;
        $operation['view_title'] = $vis_language['TXTFORUMS'];
        $spliter                 = (strstr($operation['vis_action'], '/')) ? '/' : ',';
        $action                  = explode($spliter, $operation['vis_action']);
        $header_title            = $action[3];
        $page                    = $operation['vis_page'];
        $database                = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forumObject = new class_forum($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
        $staff = new class_staff($database);
        $temp  = $staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($view_info, $view_details) = $temp;
        $limit = ($page * $view_info['page_count']) . ',' . $view_info['page_count'];
        if ($operation['vis_forum_id'] != '')
            $forumId = $operation['vis_forum_id'];
        else
            $forumId = $action[4];
        
        $forumDetails = $forumObject->get_forum('forum_id = ' . $forumId, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $forumDetails = $forumDetails[0];
        if (isset($operation['vis_sorted_by']) && $operation['vis_sorted_by'] != '') {
            if ($operation['vis_sorted_by'] == 'unanswer') {
                $sort       = '';
                $sortFilter = ' Having commentCount = 0 ';
            }
            if ($operation['vis_sorted_by'] == 'lock') {
                $sort       = '';
                $sortFilter = ' and is_lock = 1 ';
            }
            $sort = $operation['vis_sorted_by'];
        } else
            $sort = '';
        
        if ((isset($operation['criteria']) && $operation['criteria'] != '') || $forumId == '') {
            $criteria = $operation['criteria'] = (isset($operation['criteria']) && $operation['criteria'] != '') ? $operation['criteria'] : $action[3];
            $filter .= VIS_TABLE_PREFIX . 'forum_topic.title like "%' . addslashes($criteria) . '%" ' . $sortFilter;
        } else
            $filter = VIS_TABLE_PREFIX . 'forum_topic.forum_id = ' . $forumId . ' and ' . VIS_TABLE_PREFIX . 'forum_topic.is_spam=0  and ' . VIS_TABLE_PREFIX . 'forum_topic.is_approved=1 ' . $sortFilter;
        if (VIS_LOCATION_AREA == 1) {
			if ((isset($action[3]) && $action[3] == 1) || (isset($operation['vis_forum_activites']) && ($operation['vis_forum_activites'] == 'approved_topics') || $operation['vis_forum_activites'] == 'pending_topics' || $operation['vis_forum_activites'] == 'followers')) {	
				$breadcrumb['Home'] = 'index.php'; 
				$breadcrumb[$vis_language['TXTFORUMACTIVITY']] = '';
				$vis_title = $vis_language['TXTFORUMACTIVITY'];
			}
			else {
				$breadcrumb['Home'] = 'index.php'; 
				if((IS_LOGIN==0 && VIS_DEFAULT_HOME_MODULE != $operation['vis_module']) || (IS_LOGIN==1 && VIS_DEFAULT_HOME_MODULE_AFTER_LOGIN != $operation['vis_module']))  $breadcrumb[$vis_language['TXTFORUMS']] = '?/forums/forums'; 
				$breadcrumb[$forumDetails['forum_title']] = '';
				$vis_title = $vis_language['TXTFORUMS'];
			}
			$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
           $limit=($page*10).',10';
			 if ((isset($action[3]) && $action[3] == 1) || (isset($operation['vis_forum_activites']) && $operation['vis_forum_activites'] == 'approved_topics')) 
				 $filter = VIS_TABLE_PREFIX.'forum_topic.user_id='.VIS_CLIENT_ID.' and '.VIS_TABLE_PREFIX.'forum_topic.is_client=1 and '.VIS_TABLE_PREFIX.'forum_topic.is_spam=0 and '.VIS_TABLE_PREFIX.'forum_topic.is_approved=1';
			 else if ((isset($action[3]) && $action[3] == 1) || (isset($operation['vis_forum_activites']) && $operation['vis_forum_activites'] == 'pending_topics')) 
				 $filter = VIS_TABLE_PREFIX.'forum_topic.user_id='.VIS_CLIENT_ID.' and '.VIS_TABLE_PREFIX.'forum_topic.is_client=1 and '.VIS_TABLE_PREFIX.'forum_topic.is_spam=0 and '.VIS_TABLE_PREFIX.'forum_topic.is_approved=0';
			
			 list($forumInfo, $forumTopic) = $forumObject->get_topic($filter, $limit, $sort, VIS_STAFF_ID, VIS_LOCATION_AREA);
			 
			  if ((isset($operation['vis_forum_activites']) && $operation['vis_forum_activites'] == 'followers')) {
				 $filter = VIS_TABLE_PREFIX.'forum_topic_followers.topic_id='.VIS_TABLE_PREFIX.'forum_topic.topic_id and '.VIS_TABLE_PREFIX.'forum_topic_followers.follower_id='.VIS_CLIENT_ID.' and '.VIS_TABLE_PREFIX.'forum_topic.is_spam=0 and '.VIS_TABLE_PREFIX.'forum_topic_followers.follower_type=1';
				  list($forumInfo, $forumTopic) = $forumObject->get_topic($filter, $limit, $sort, VIS_STAFF_ID, VIS_LOCATION_AREA,$operation['vis_forum_activites']);
			 }
        } else {
            list($forumInfo, $forumTopic) = $forumObject->get_topic($filter, $limit, $sort, VIS_STAFF_ID, VIS_LOCATION_AREA);
        }
        if (VIS_LOCATION_AREA == 1){
           $comment_count=array();
			for($i=0; $i<count($forumTopic); $i++){
				$filter		= VIS_TABLE_PREFIX . 'forum_comment.topic_id = ' . $forumTopic[$i]['topic_id'] . ' and is_spam=0';
				$comment   	= $forumObject->get_comments($filter, $userid, $user);
				$count=0;if($comment!=-1) {
			    for($j=0;$j<count($comment);$j++) { 
				   if(($comment[$j]['is_approved'] == 1 ) || ($comment[$j]['is_approved'] == 0 && $comment[$j]['poster_id'] == VIS_CLIENT_ID )){
					 $count++;
				   }				  
			    }
				$comment_count[$i]=$count;
			}
        }
        }
        $page_count=($forumInfo['total']==0)?0:ceil($forumInfo['total']/10);
        $view_info['page_count']  = ($forumInfo['total'] == 0) ? 0 : ceil($forumInfo['total'] / $view_info['page_count']);
        $forumInfo['forum_count'] = (!$forumTopic || $forumTopic == -1) ? 0 : $forumInfo['total'];
        $forumInfo['page']        = $page; //*$view_info['page_count'];
        $view_info['view_count']  = count($view_details);
        $view_info['view_title']  = $operation['view_title'];
		 if ((isset($action[3]) && $action[3] == 1) || isset($operation['vis_forum_activites'])) {			
			 $header_title = $vis_language['TXTFORUMACTIVITY'];
			 if(isset($operation['vis_forum_activites'])){
					include(VIS_PATH_TEMPLATE.'client_topic_list.php');
			 }
			 else {
			 if(!isset($operation['vis_forum_activites'])){$operation['vis_forum_activites']='approved_topics';}
			 if (!defined('IS_WHMCS'))
					include(VIS_PATH_TEMPLATE . 'header.php');
				else
					echo '<link href="' . VIS_PATH_STYLE . 'vis_style.css" rel="stylesheet" />';
				include(VIS_PATH_TEMPLATE . 'client_topic_list.php');
				if (!defined('IS_WHMCS'))
					include(VIS_PATH_TEMPLATE . 'footer.php');
			 }
			return true;
		 }
        if (VIS_LOCATION_AREA == 1) {
			if(isset($operation['vis_sorted_by'])){
					include(VIS_PATH_TEMPLATE.'forum_topic_list.php');
			}
			else {
				if (!defined('IS_WHMCS'))
					include(VIS_PATH_TEMPLATE . 'header.php');
				else
					echo '<link href="' . VIS_PATH_STYLE . 'vis_style.css" rel="stylesheet" />';
				include(VIS_PATH_TEMPLATE . 'forum_topic_list.php');
				if (!defined('IS_WHMCS'))
					include(VIS_PATH_TEMPLATE . 'footer.php');
			}
            return true;
        }
        include(VIS_PATH_TEMPLATE . 'forum_topic_list.php');
     
    }
    //function for get all forum categories 
    function get_all_categories($operation)
    {
        global $vis_language;
        $database = new class_database();
        
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forumObject    = new class_forum($database);
        $categoryFilter = '';
        $domainDetails  = $forumObject->get_right_panel_forum_cnt('', VIS_STAFF_ID, VIS_LOCATION_AREA);
        include(VIS_PATH_TEMPLATE . 'forum_all_category_list.php');
    }
    
    //get all activity
    function forum_filter($operation)
    {
        global $vis_language;
        $database = new class_database();
        $spliter  = (strstr($operation['vis_action'], '/')) ? '/' : ',';
        $action   = explode($spliter, $operation['vis_action']);
        $page     = (isset($operation['vis_page']) && is_numeric($operation['vis_page'])) ? $operation['vis_page'] : 0;
        
        $operation['view_title'] = $vis_language['TXTFORUMS'];
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forumObject = new class_forum($database);
        
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
        $staff = new class_staff($database);
        $temp  = $staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($view_info, $view_details) = $temp;
        $limit     = ($page * $view_info['page_count']) . ',' . $view_info['page_count'];
        $filter_id = $action[4];
        if ($filter_id == '') {
            $filter_id = $operation['vis_filter_id'];
        }
        if ($filter_id == 1) {
            $filter                 = VIS_TABLE_PREFIX . 'forum_activity_log.is_approved = 1 AND ' . VIS_TABLE_PREFIX . 'forum_activity_log.is_spam = 0';
            $operation['sub_title'] = $vis_language['TXTALLACTIVITY'];
        } // All activity
        else if ($filter_id == 2) {
            $filter                 = VIS_TABLE_PREFIX . 'forum_activity_log.is_approved = 1 AND ' . VIS_TABLE_PREFIX . 'forum_activity_log.is_client = 0 and ' . VIS_TABLE_PREFIX . 'forum_activity_log.poster_id = ' . VIS_STAFF_ID . ' and ' . VIS_TABLE_PREFIX . 'forum_activity_log.is_spam = 0';
            $operation['sub_title'] = $vis_language['TXTYOURTOPICACTIVITY'];
        } //My activity
        else if ($filter_id == 3) {
            $filter                 = VIS_TABLE_PREFIX . 'forum_activity_log.is_approved = 0 and ' . VIS_TABLE_PREFIX . 'forum_activity_log.is_spam = 0';
            $operation['sub_title'] = $vis_language['TXTWAITINGFORAPPROVAL'];
        } //Waiting for approval
        else if ($filter_id == 4) {
            $filter                 = VIS_TABLE_PREFIX . 'forum_activity_log.is_spam = 1';
            $operation['sub_title'] = $vis_language['TXTSPAM'];
        } //Spam
        $quick_view = $forumObject->get_activity_sortng_counts($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,$filter_id);
        $sort_by    = $operation['vis_sorted_by'];
        $filter .= (isset($operation['vis_sorted_by']) && $operation['vis_sorted_by'] != '') ? ' and ' . $operation['vis_sorted_by'] : '';
        list($forumInfo, $forumTopic) = $forumObject->get_all_activity($filter, $page, VIS_STAFF_ID, VIS_LOCATION_AREA,$filter_id);
        list($allForumInfo, $allTopic) = $forumObject->get_all_activity($filter, '', VIS_STAFF_ID, VIS_LOCATION_AREA,$filter_id);
        $total_Activities         = $allForumInfo['total'];
        $total_pages              = ceil($total_Activities / 10);
        $load_more_activities     = ($total_pages > $page + 1) ? $page : '';
        $view_info['page_count']  = ($forumInfo['total'] == 0) ? 0 : ceil($forumInfo['total'] / $view_info['page_count']);
        $forumInfo['forum_count'] = (!$forumTopic || $forumTopic == -1) ? 0 : count($forumTopic);
        $forumInfo['page']        = $page; //*$view_info['page_count'];
        $view_info['view_count']  = count($view_details);
        $view_info['view_title']  = $operation['view_title'];
        if (!isset($operation['vis_page'])) {
            include(VIS_PATH_TEMPLATE . 'forum_all_activies.php');
        } else {
            include(VIS_PATH_TEMPLATE . 'load_forum_activity.php');
        }
    }
    //get topic list function - start
    function topic_details($operation)
    {
        global $vis_language;
        $operation['view_title'] = $vis_language['TXTFORUMS'];
        $spliter                 = (strstr($operation['vis_action'], '/')) ? '/' : ',';
        $action                  = explode($spliter, $operation['vis_action']);
        $database                = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forumObject = new class_forum($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'selfhelp.php');
        $selfhelpObject = new class_selfhelp($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
        $staff_object = new class_staff($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
        $client_object = new class_client($database);
        $staff         = $staff_object->get_staff('staff_id=' . VIS_STAFF_ID, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $filter        = VIS_TABLE_PREFIX . 'forum_topic.topic_id =' . ((isset($operation['vis_topic_id']) && $operation['vis_topic_id'] != '') ? $operation['vis_topic_id'] : $action[4]);
        list($forumInfo, $forumTopic) = $forumObject->get_topic($filter, $limit, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $forumTopic = $forumTopic[0];
        $signaturedata=$staff_object->get_signature('staff_id='.VIS_STAFF_ID.' and department_id='.$forumTopic['domain_id'].' and is_forum=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        if($signaturedata!=-1) $signature=$signaturedata[0]['content'];
        $attachment = $selfhelpObject->get_attachment('parent_id=' . $forumTopic['topic_id'] . ' and parent_type=9', VIS_STAFF_ID, VIS_LOCATION_AREA);
        if (VIS_LOCATION_AREA == 1){
			$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
            $limit=($page*10).',10';
            $filter = VIS_TABLE_PREFIX . 'forum_comment.topic_id = ' . $forumTopic['topic_id'] . ' and is_spam=0 and (is_approved=1 or (is_approved=0 and poster_id='.VIS_CLIENT_ID.'))';
            $comment_count     = $forumObject->get_comments($filter, $userid, $user);
            $comment     = $forumObject->get_comments($filter, $userid, $user, $limit);
            $page_count=(count($comment_count)==0)?0:ceil(count($comment_count)/10);
        }else{
            $filter = VIS_TABLE_PREFIX . 'forum_comment.topic_id = ' . $forumTopic['topic_id'];
            $comment     = $forumObject->get_comments($filter, $userid, $user);
		}
        $posterId    = (VIS_LOCATION_AREA == 1) ? VIS_CLIENT_ID : VIS_STAFF_ID;
        $postertype  = (VIS_LOCATION_AREA == 1) ? 1 : 0;
        $filter      = VIS_TABLE_PREFIX . 'forum_topic_likes.parent_id =' . ((isset($operation['vis_topic_id']) && $operation['vis_topic_id'] != '') ? $operation['vis_topic_id'] : $action[4]) . ' and poster_id=' . $posterId . ' and ' . VIS_TABLE_PREFIX . 'forum_topic_likes.parent_type=0 and poster_type=' . $postertype;
        $topic_likes = $forumObject->get_topic_likes($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        
        $followers_filter = VIS_TABLE_PREFIX . 'forum_topic_followers.topic_id =' . ((isset($operation['vis_topic_id']) && $operation['vis_topic_id'] != '') ? $operation['vis_topic_id'] : $action[4]) . ' and follower_id=' . $posterId . ' and follower_type=' . $postertype;
        $topic_followers  = $forumObject->get_topic_followers($followers_filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if (VIS_LOCATION_AREA == 1) {
			$breadcrumb['Home'] = 'index.php'; 
			list($client_info, $client_forum_signature)=$client_object->get_client('client_id='.VIS_CLIENT_ID,'',0,'',0,1);
			if($client_forum_signature!=-1) $signature=$client_forum_signature[0]['forum_signature_content'];
			if($signature!=''){
				if (defined('VIS_HEAD_MENU_HTML_EDITOR') && VIS_HEAD_MENU_HTML_EDITOR != 1) {  	
					$signature = get_plain_text("<br /><br />".$signature);	
				}
				else $signature = "<br /><br />".$signature;
			}
			if((IS_LOGIN==0 && VIS_DEFAULT_HOME_MODULE != $operation['vis_module']) || (IS_LOGIN==1 && VIS_DEFAULT_HOME_MODULE_AFTER_LOGIN != $operation['vis_module']))  $breadcrumb[$vis_language['TXTFORUMS']] = '?/forums/forums'; 
			$breadcrumb[$forumTopic['forum_title']] = '?/forums/topic-list/'.$forumTopic['forum_title'].'/'.$forumTopic['forum_id'];
			$breadcrumb[$forumTopic['title']] = '';
			$vis_title = $vis_language['TXTFORUMS'];
            $header_title = $forumTopic['title'];
            list($clinfo, $client) = $client_object->get_client('client_id=' . VIS_CLIENT_ID, '', 0, '', VIS_CLIENT_ID, VIS_LOCATION_AREA);
            if(isset($operation['vis_page']) && is_numeric($operation['vis_page']))
            {
				include(VIS_PATH_TEMPLATE . 'topic_comment_list.php');
			}
			else{
				if (!defined('IS_WHMCS'))
					include(VIS_PATH_TEMPLATE . 'header.php');
				else
					echo '<link href="' . VIS_PATH_STYLE . 'vis_style.css" rel="stylesheet" />';
				include(VIS_PATH_TEMPLATE . 'forum_topic.php');
				if (!defined('IS_WHMCS'))
                include(VIS_PATH_TEMPLATE . 'footer.php');
				return true;
			}
        }
        else
        include(VIS_PATH_TEMPLATE . 'topic_details.php');
    }
    
    // function for display forum edit form
    function forum_details($operation)
    {
        global $vis_language;
        $operation['view_title'] = $vis_language['TXTFORUMS'];
        $spliter                 = (strstr($operation['vis_action'], '/')) ? '/' : ',';
        $action                  = explode($spliter, $operation['vis_action']);
        $forumId                 = $operation['vis_forum_id'];
        $forumTitle              = $operation['vis_domain'] . " : " . $operation['categoryName'] . " : " . $operation['forumTitle'];
        $database                = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forumObject = new class_forum($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
        $sett_object = new class_setting($database);
        
        $forum_lang = $sett_object->get_translation(16, 'data_id=' . $forumId, VIS_STAFF_ID, VIS_LOCATION_AREA);
        
        list($language_info, $language_details) = $sett_object->get_language('is_custom=1 and is_enabled=1', '', 0, 0, VIS_STAFF_ID, VIS_LOCATION_AREA);
        
        $domain_details = $forumObject->get_forum_category_domain_list(VIS_TABLE_PREFIX . 'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $filter         = VIS_TABLE_PREFIX . 'forum.forum_id =' . $forumId;
        $forumDetails   = $forumObject->get_forum($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $forumDetails   = $forumDetails[0];
        $forumTitle     = $forumDetails['domain_name'] . " : " . $forumDetails['category_name'] . " : " . $forumDetails['forum_title'];
        
        $domain_id              = (isset($operation['vis_domain_id']) && is_numeric($operation['vis_domain_id'])) ? $operation['vis_domain_id'] : $domain_id = $forumDetails['domain_id'];
        $forum_category_details = $forumObject->get_forum_category('domain_id=' . $domain_id, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $forum_category_details['description'] = get_plain_text($forum_category_details['description']);
        $forumDetails['description'] = get_plain_text($forumDetails['description']);
        include(VIS_PATH_TEMPLATE . 'forum_details_form.php');
    }
    
    // function for update forum data
    function update_forum($operation)
    {
        global $vis_language;
        $database                = new class_database();
        $operation['view_title'] = $vis_language['TXTFORUMS'];
        $data                    = parse_form_array($operation['vis_action']);
        if ($data['vis_forum_title'] == '') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGREQFLDTIT'] . '"); </script>';
            return false;
        }
        
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forumObject = new class_forum($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'subsetting.php');
        $sub_object = new class_subsetting($database);
        $data['vis_forum_post_area'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_forum_post_area']);
        $result     = $forumObject->update_forum($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if (!$result) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); </script>';
            return false;
        } else {
            $activity_log = $sub_object->add_staff_activity_log("Forum updated - " . $data['vis_forum_title'], VIS_STAFF_ID,9,VIS_LOCATION_AREA);
            echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"forums", "vis_operation":"forum_list","vis_forum_category":"' . $data['vis_forum_category'] . '","vis_action":"#/forums/forum_list/' . $data['vis_action_title'] . '/' . $data['vis_forum_category'] . '"});$("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"forums"}); $(".modal").modal("hide");</script>';
        }
        $database->database_disconnect();
        return true;
    }
    function get_delete_topic($operation)
    {
        global $vis_language;
        $message_info['vis_form_title'] = $vis_language['TXTDELETETOPIC'];
        $message_info['vis_message']    = $vis_language['MSGDELETETOPIC'];
        $vis_page                       = (isset($operation['vis_page'])) ? $operation['vis_page'] : '';
        $message_info['vis_event']      = "$(this).visExecution('load_operations', {'vis_module':'forums', 'vis_operation':'delete_topic', 'vis_topic_id':" . $operation['vis_topic_id'] . "})";
        include(VIS_PATH_TEMPLATE . 'confirm_delete.php');
        return true;
    }
    function delete_topic($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forumObject = new class_forum($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'subsetting.php');
        $sub_object = new class_subsetting($database);
        list($forumInfo, $topic) = $forumObject->get_topic('topic_id=' . $operation['vis_topic_id'], $limit, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if (VIS_LOCATION_AREA == 2) {
            $ret = $forumObject->delete_topic($operation['vis_topic_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
            if (!$ret) {
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); </script>';
                return false;
            } else {
                $activity_log = $sub_object->add_staff_activity_log("Topic deleted - " . $topic[0]['title'], VIS_STAFF_ID,9,VIS_LOCATION_AREA);
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '"); $("#vis_workpanel_div").visExecution("load_module","' . $topic[0]['domain_name'] . ' : ' . $topic[0]['category_name'] . ' : ' . $topic[0]['forum_title'] . '/' . $topic[0]['forum_id'] . '", {"vis_module":"forums", "vis_operation":"get_topic_list" , "vis_action":"#/forums/get_topic_list/' . $topic[0]['domain_name'] . ' : ' . $topic[0]['category_name'] . ' : ' . $topic[0]['forum_title'] . '/' . $topic[0]['forum_id'] . '"});$("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"forums"}); </script>';
            }
        }
        $database->database_disconnect();
        return true;
    }
    //Set comment for forum topic
    function set_comment($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forumObject = new class_forum($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'subsetting.php');
        $sub_object = new class_subsetting($database);
        $data       = (isset($operation['vis_action']) && $operation['vis_action'] != '') ? parse_form_array($operation['vis_action']) : array_map("addslashes", $operation);
        $data       = (!empty($data)) ? $data : $operation;
        if (trim(strip_tags($data['vis_forum_comment'],"<img>")) == '') {
            if (VIS_LOCATION_AREA == 2) {
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGINFOMISS'] . '"); </script>';
                return false;
            }
            if(VIS_LOCATION_AREA == 1) {
				 $operation['vis_msg'] = $vis_language['MSGINFOMISS'];
                    echo json_encode(array(
                        'vis_submitted' => 'false',
                        'vis_msg' => $operation['vis_msg']
                    ));
                    return false;
			}
        }
        list($forumInfo, $topic) = $forumObject->get_topic('topic_id=' . $data['vis_topic_id'], $limit, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if (defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR != 1)
        $data['vis_forum_comment'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_forum_comment']);
        $ret = $forumObject->set_comment($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if (VIS_LOCATION_AREA == 2) {
            if (!$ret) {
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " ' . $vis_language['MSGERROPRT'] . '"); </script>';
                return false;
            } else {
                $activity_log = $sub_object->add_staff_activity_log("Added new comment on topic - " . $topic[0]['title'], VIS_STAFF_ID,9,VIS_LOCATION_AREA);
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '"); $(\'#vis_workpanel_div\').visExecution(\'load_area\', {\'vis_module\':\'forums\', \'vis_operation\':\'topic_details\', \'vis_topic_id\':' . $data['vis_topic_id'] . ',\'vis_action\':\'' . $data['vis_action'] . '\'}) </script>';
                
            }
            $data['parent_type'] = 1;
            $data['poster_id']   = VIS_STAFF_ID;
            
        } else if (VIS_LOCATION_AREA == 1) {
            if ($ret) {
				$activity_log = $sub_object->add_staff_activity_log("Added new comment on topic - " . $topic[0]['title'], VIS_CLIENT_ID,9,VIS_LOCATION_AREA);
				$page=0;
				$limit=($page*10).',10';
				$filter = VIS_TABLE_PREFIX . 'forum_comment.topic_id = ' . $data['vis_topic_id'] . ' and is_spam=0 and (is_approved=1 or (is_approved=0 and poster_id='.VIS_CLIENT_ID.'))';
				$comment = $forumObject->get_comments($filter, $userid, $user, $limit);
				$comment_count     = $forumObject->get_comments($filter, $userid, $user);
				$page_count=(count($comment_count)==0)?0:ceil(count($comment_count)/10);
				$forumTopic['topic_id']=$data['vis_topic_id'];
				ob_start();
				include(VIS_PATH_TEMPLATE.'topic_comment_list.php');
				$comments = ob_get_clean();
				ob_end_flush();
				
                $operation['vis_msg'] = $vis_language['MSGSUCCOPRT'];
                echo json_encode(array(
                    'vis_submitted' => 'true',
                    'vis_msg' => $operation['vis_msg'],
                    'comments' => $comments
                ));
            }
        }
        if ($ret) {
            if (VIS_LOCATION_AREA == 1)
                $data['vis_domain'] = $operation['vis_domain_id'];
            $data['vis_operation']  = 'set_topic_comment';
            $data['vis_comment_id'] = $ret;
            global $operation_hnd;
            $operation_hnd->check_automation($data, $database);
        }
        $database->database_disconnect();
        return true;
    }
    // delete topic comment
    function get_delete_comment($operation)
    {
        global $vis_language;
        $message_info['vis_form_title'] = $vis_language['TXTDELETETOPICCOMMENT'];
        $message_info['vis_message']    = $vis_language['MSGSURE'];
        $vis_page                       = (isset($operation['vis_page'])) ? $operation['vis_page'] : '';
        $message_info['vis_event']      = "$(this).visExecution('load_operations', {'vis_module':'forums', 'vis_operation':'delete_topic_comment', 'vis_topic_id':" . $operation['vis_topic_id'] . ",'vis_comment_id':" . $operation['vis_comment_id'] . ",'vis_page':'" . $vis_page . "'})";
        include(VIS_PATH_TEMPLATE . 'confirm_delete.php');
        return true;
    }
    function delete_topic_comment($operation)
    {
        global $vis_language;
        if (!isset($operation['vis_topic_id']) && !isset($operation['vis_comment_id']) && isset($operation['vis_action']) && $operation['vis_action'] != '') {
            $data                        = explode('/', $operation['vis_action']);
            $operation['vis_topic_id']   = $data[3];
            $operation['vis_comment_id'] = $data[4];
        }
        if (!isset($operation['vis_topic_id'])) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGARTICLEIDNTFND'] . '"); </script>';
            return false;
        }
        $database = new class_database();
        //$data=(isset($operation['vis_action']) && $operation['vis_action']!='')?parse_form_array($operation['vis_action']):$operation;
        // $data = (!empty($data))?$data:$operation;
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forumObject = new class_forum($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'subsetting.php');
        $sub_object = new class_subsetting($database);
        list($forumInfo, $topic) = $forumObject->get_topic('topic_id=' . $operation['vis_topic_id'], $limit, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $comment_details = $forumObject->get_comments('comment_id=' . $operation['vis_comment_id'], '', '', $userid, $user, $limit = '');
        if (VIS_LOCATION_AREA == 2) {
            if ($topic[0]['user_id'] == VIS_STAFF_ID || $comment_details[0]['poster_id'] == VIS_STAFF_ID) {
                $ret = $forumObject->delete_topic_comment($operation['vis_comment_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
                if (!$ret) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); </script>';
                    return false;
                } else {
                    $activity_log = $sub_object->add_staff_activity_log("Deleted comment on topic - " . $topic[0]['title'], VIS_STAFF_ID,9,VIS_LOCATION_AREA);
                    $action       = '#/forums/topic_details/' . $topic[0]['title'] . '/' . $operation['vis_topic_id'];
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '"); $(\'#vis_workpanel_div\').visExecution(\'load_area\', {\'vis_module\':\'forums\', \'vis_operation\':\'topic_details\', \'vis_topic_id\':' . $operation['vis_topic_id'] . ',\'vis_action\':\'' . $action . '\'}) </script>';
                }
            } else
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGACCSSDND'] . '"); </script>';
        } else if (VIS_LOCATION_AREA == 1) {
            if ($comment_details[0]['poster_id'] == VIS_CLIENT_ID) {
                $ret = $forumObject->delete_topic_comment($operation['vis_comment_id'], VIS_CLIENT_ID, VIS_LOCATION_AREA);
                if ($ret) {
                    $operation['vis_msg'] = $vis_language['MSGSUCCOPRT'];
                    echo json_encode(array(
                        'vis_submitted' => 'true',
                        'vis_msg' => $operation['vis_msg']
                    ));
                } else {
                    $operation['vis_msg'] = $vis_language['MSGERROPRT'];
                    echo json_encode(array(
                        'vis_submitted' => 'false',
                        'vis_msg' => $operation['vis_msg']
                    ));
                }
            } else
                echo '<div class="vis_error_message">' . $vis_language['MSGACCSSDND'] . '</div>';
        }
        $database->database_disconnect();
        return true;
    }
    // update topic form
    function edit_topic($operation)
    {
        global $vis_language;
        $operation['view_title'] = $vis_language['TXTFORUMS'];
        $spliter                 = (strstr($operation['vis_action'], '/')) ? '/' : ',';
        $action                  = explode($spliter, $operation['vis_action']);
        $database                = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forum_object = new class_forum($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'selfhelp.php');
        $selfhelpObject = new class_selfhelp($database);
        list($forumInfo, $topic) = $forum_object->get_topic('topic_id=' . $action[4], $limit, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $topic         = $topic[0];
        if (defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR != 1) {  	
			$topic['description'] = get_plain_text($topic['description']);	
		}
        $forum_details = $forum_object->get_forum(VIS_TABLE_PREFIX . 'forum.forum_cat_id=' . $topic['forum_cat_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        $attachments   = $selfhelpObject->get_attachment('parent_id=' . $action[4] . ' and parent_type=9', VIS_STAFF_ID, VIS_LOCATION_AREA);
        include(VIS_PATH_TEMPLATE . 'update_forum_topic.php');
    }
    // update topic function
    function update_forum_topic($operation)
    {
        global $vis_language;
        $data = parse_form_array($operation['vis_action']);
        if (!isset($data['vis_forum_title']) || trim($data['vis_forum_title'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGREQFLDTIT'] . '"); </script>';
            return false;
        }
        if(!isset($data['vis_forum_topic_post_area']) || trim(strip_tags($data['vis_forum_topic_post_area'],"<img>")) == '') {
			 echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGREQFLDDESC'] . '"); </script>';
            return false;
           
        }
        if (defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR ==0) 
        $data['vis_forum_topic_post_area'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_forum_topic_post_area']);
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forum_object = new class_forum($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'subsetting.php');
        $sub_object = new class_subsetting($database);
        list($forumInfo, $topic) = $forum_object->get_topic('topic_id=' . $data['vis_topic_id'], $limit, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret = $forum_object->update_topic($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if (!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); </script>';
            return false;
        } else {
            $activity_log = $sub_object->add_staff_activity_log("Topic updated - " . $topic[0]['title'], VIS_STAFF_ID,9,VIS_LOCATION_AREA);
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " ' . $vis_language['MSGSUCCOPRT'] . '"); $("#vis_workpanel_div").visExecution("load_module","' . $topic[0]['topic_url'] . '/' . $topic[0]['topic_id'] . '", {"vis_module":"forums", "vis_operation":"topic_details", "vis_action":"#/forums/topic_details/' . $topic[0]['topic_url'] . '/' . $topic[0]['topic_id'] . '"}); </script>';
        }
        $database->database_disconnect();
        return true;
    }
    // delete forum
    function get_delete_forum($operation)
    {
        global $vis_language;
        $message_info['vis_form_title'] = $vis_language['TXTDELETEFORUM'];
        $message_info['vis_message']    = $vis_language['MSGDELETEFORUM'];
        $vis_page                       = (isset($operation['vis_page'])) ? $operation['vis_page'] : '';
        $message_info['vis_event']      = "$(this).visExecution('load_operations', {'vis_module':'forums', 'vis_operation':'delete_forum', 'vis_forum_id':" . $operation['vis_forum_id'] . ", 'vis_forum_category':" . $operation['vis_forum_category'] . ", 'vis_domain':" . $operation['vis_domain'] . "})";
        include(VIS_PATH_TEMPLATE . 'confirm_delete.php');
        return true;
    }
    function delete_forum($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forumObject = new class_forum($database);
        //list($forumInfo, $forum) =$forumObject->get_forum('forum_id='.$operation['vis_forum_id'],$limit, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if (VIS_LOCATION_AREA == 2) {
            $ret = $forumObject->delete_forum($operation['vis_forum_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
            if (!$ret) {
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); </script>';
                return false;
            } else {
				$forum_category_details = $forumObject->get_forum_category_list('domain_id=' . $operation['vis_domain'].' and '.VIS_TABLE_PREFIX.'forum_category.forum_cat_id='.$operation['vis_forum_category'], VIS_STAFF_ID, VIS_LOCATION_AREA);
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '"); $("#vis_workpanel_div").visExecution("load_area", {"vis_module":"forums", "vis_operation":"forum_list","vis_action":"#/forums/forum_list/'.$forum_category_details[0]['category_name'].'/'.$forum_category_details[0]['forum_cat_id'].'"});$("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"forums"});</script>';
            }
        }
        $database->database_disconnect();
        return true;
    }
    function category_details($operation)
    {
        global $vis_language;
        $operation['view_title'] = $vis_language['TXTUPDATECATEGORY'];
        $category_id             = $operation['vis_category_id'];
        $database                = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forumObject = new class_forum($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $object = new class_ticket($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
        $sett_object    = new class_setting($database);
        $domain_details = $object->get_domain(VIS_TABLE_PREFIX . 'domain.is_enabled=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        
        $category_lang = $sett_object->get_translation(17, 'data_id=' . $category_id, VIS_STAFF_ID, VIS_LOCATION_AREA);
        
        list($language_info, $language_details) = $sett_object->get_language('is_custom=1 and is_enabled=1', '', 0, 0, VIS_STAFF_ID, VIS_LOCATION_AREA);
        // and location = 17 and data_id = '.$category_id
        
        $filter       = VIS_TABLE_PREFIX . 'forum_category.forum_cat_id=' . $category_id;
        $categoryData = $forumObject->get_forum_category($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $categoryData = $categoryData[0];
        $categoryData['description'] = get_plain_text($categoryData['description']);
        include(VIS_PATH_TEMPLATE . 'forum_category_details.php');
        return true;
    }
    
    function update_forum_category($operation)
    {
        global $vis_language;
        if (isset($operation['vis_action']))
            $data = parse_form_array($operation['vis_action']);
        else
            $data = $operation;
        if (trim($data['vis_cat_title']) == '') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGINFOMISS'] . '");</script>';
            return false;
        }
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forumObject = new class_forum($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'subsetting.php');
        $sub_object = new class_subsetting($database);
        $data['vis_description'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_description']);
        $result     = $forumObject->update_category($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if (!$result) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); </script>';
            return false;
        } else {
            $activity_log = $sub_object->add_staff_activity_log("Forum category updated - " . $data['vis_cat_title'], VIS_STAFF_ID,9,VIS_LOCATION_AREA);
            echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '"); $("#vis_workpanel_div").visExecution("load_module","All category",{"vis_module":"forums", "vis_operation":"get_all_categories",});$("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"forums"}); $(".modal").modal("hide");</script>';
        }
        $database->database_disconnect();
        return true;
    }
    function get_category_delete($operation)
    {
        global $vis_language;
        $message_info['vis_form_title'] = $vis_language['TXTDELETEFORUMCATEGORY'];
        $message_info['vis_message']    = $vis_language['MSGDELETEFORUMCATEGORY'];
        $vis_page                       = (isset($operation['vis_page'])) ? $operation['vis_page'] : '';
        $message_info['vis_event']      = "$(this).visExecution('load_operations', {'vis_module':'forums', 'vis_operation':'delete_category', 'vis_category_id':" . $operation['vis_category_id'] . "})";
        include(VIS_PATH_TEMPLATE . 'confirm_delete.php');
        return true;
    }
    function delete_category($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forumObject = new class_forum($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'subsetting.php');
        $sub_object = new class_subsetting($database);
        if (VIS_LOCATION_AREA == 2) {
            $forum_category_details = $forumObject->get_forum_category('forum_cat_id=' . $operation['vis_category_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
            $ret                    = $forumObject->delete_category($operation['vis_category_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
            if (!$ret) {
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); </script>';
                return false;
            } else {
                $activity_log = $sub_object->add_staff_activity_log("Forum category deleted - " . $forum_category_details[0]['category_name'], VIS_STAFF_ID,9,VIS_LOCATION_AREA);
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '");
   				$("#vis_workpanel_div").visExecution("load_module","All category", {"vis_module":"forums", "vis_operation":"get_all_categories"}); $("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"forums"}); </script>';
            }
        }
        $database->database_disconnect();
        return true;
    }
    function view_forums_group($operation)
    {
        global $vis_language;
        $header_title = $vis_language['TXTFORUMS'];
        $breadcrumb['Home'] = 'index.php'; 
        $breadcrumb[$vis_language['TXTFORUMS']] = ''; 
        $vis_title = $vis_language['TXTFORUMS'];
        $database     = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forum_object   = new class_forum($database);
        $forum_category = $forum_object->get_forum_category('access_type = 0 and domain_id=' . VIS_DOMAIN, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $forumDataChk   = $forum_object->get_forum_category_list('domain_id=' . VIS_DOMAIN . ' and ' . VIS_TABLE_PREFIX . 'forum.topic_access=1', VIS_STAFF_ID, VIS_LOCATION_AREA);
        
        for ($i = 0; $i < count($forum_category); $i++) {
            $filter = 'display_status!=2';
            $filter = (IS_LOGIN) ? 'display_status!=2' : 'display_status=0';
            $filter .= ' and ' . VIS_TABLE_PREFIX . 'forum.forum_cat_id=' . $forum_category[$i]['forum_cat_id'];
            $forum        = $forum_object->get_forum($filter, -1, true, VIS_DOMAIN, VIS_LOCATION_AREA);
            $forum_list[] = $forum;
            for ($j = 0; $j < count($forum); $j++) {
                $filter = VIS_TABLE_PREFIX . 'forum.forum_cat_id=' . $forum_category[$i]['forum_cat_id'] . ' and ' . VIS_TABLE_PREFIX . 'forum_topic.forum_id=' . $forum[$j]['forum_id'] . ' and ' . VIS_TABLE_PREFIX . 'forum_topic.is_spam=0 and ' . VIS_TABLE_PREFIX . 'forum_topic.is_approved=1';
                list($forumInfo, $forumTopic) = $forum_object->get_topic($filter, '', VIS_CLIENT_ID, VIS_LOCATION_AREA);
                $forum_topic_list[] = $forumTopic;
                $forumInfo_count[$i][$j]  = $forumInfo;
            }
        }
        if (!defined('IS_WHMCS'))
            include(VIS_PATH_TEMPLATE . 'header.php');
        else
            echo '<link href="' . VIS_PATH_STYLE . 'vis_style.css" rel="stylesheet" />';
        include(VIS_PATH_TEMPLATE . 'forum_category.php');
        if (!defined('IS_WHMCS'))
            include(VIS_PATH_TEMPLATE . 'footer.php');
    }
    function add_topic($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forum_object = new class_forum($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'subsetting.php');
        $sub_object = new class_subsetting($database);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
        $sett_obj       = new class_setting($database);
        $operation= array_map("addslashes", $operation);
        if (!isset($operation['vis_forum_title']) || trim($operation['vis_forum_title']) == '' || !isset($operation['vis_forum_topic_post_area']) || trim(strip_tags($operation['vis_forum_topic_post_area'],"<img>")) == '' || !isset($operation['vis_forum']) || $operation['vis_forum'] == '') {
            $operation['vis_error_message'] = $vis_language['MSGINFOMISS'];
            echo json_encode(array(
                'vis_msg' => $operation['vis_error_message']
            ));
            return false;
        }
        
        if (VIS_LOCATION_AREA == 1 && (isset($operation['captchacode'])&& ((trim($operation['captchacode'])!=strtoupper($_SESSION['random_number'])) && (trim($operation['captchacode'])!=$_SESSION['random_number'])))) {
            $operation['message'] = $vis_language['MSGIMGVERIFY'];
            echo json_encode(array(
                'vis_msg' => $operation['message']
            ));
            return false;
        }
        if (defined('VIS_HEAD_MENU_HTML_EDITOR') && VIS_HEAD_MENU_HTML_EDITOR != 1) 
        $operation['vis_forum_topic_post_area'] = str_replace(array("\r\n","\r","\n"),"<br>",$operation['vis_forum_topic_post_area']);
        $ret                                    = $forum_object->add_new_forum_topic($operation, VIS_CLIENT_ID, VIS_LOCATION_AREA);
        $module_setting = $sett_obj->get_module_setting('domain_id=' . $operation['vis_domain_id'] . ' and module_id=12', VIS_STAFF_ID, VIS_LOCATION_AREA);
        if ($ret) {
			$staff_activity_log = $sub_object->add_staff_activity_log("New forum topic added - " . $operation['vis_forum_title'],VIS_CLIENT_ID,9,VIS_LOCATION_AREA);
            $operation['vis_operation'] = 'new_forum_topic';
            $operation['vis_topic_id']  = $ret;
            $operation['vis_domain']    = $operation['vis_domain_id'];
            global $operation_hnd;
            $operation_hnd->check_automation($operation, $database);
            if($module_setting['vis_approve']=='0'){
				echo json_encode(array(
					'vis_submitted' => 'True',
					'vis_msg' => $vis_language['MSGTOPICAWITINGMOD']
				));
			} else {
				echo json_encode(array(
				    'vis_submitted' => 'true',
					'vis_msg' => $vis_language['MSGSUCCOPRT']
				));
			}
        }
    }
    
    function show_user_details($operation)
    {
        
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'ticket.php');
        $ticket_object = new class_ticket($database);
        if ($operation['vis_submitter'] == 1) {
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'client.php');
            $client_object = new class_client($database);
            $user_details  = $client_object->get_client(VIS_TABLE_PREFIX . 'client.client_id=' . $operation['vis_submitter_id'], 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
            $user_details  = $user_details[1][0];
        } else if ($operation['vis_submitter'] == 0) {
            include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'staff.php');
            $staff_object               = new class_staff($database);
            $user_details               = $staff_object->get_staff('staff_id=' . $operation['vis_submitter_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
            $user_details               = $user_details[0];
            $staff_gr_details           = $staff_object->get_staff_group('group_id =' . $user_details['group_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
            $user_details['group_name'] = $staff_gr_details[0]['group_name'];
        }
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'setting.php');
        $sett_obj       = new class_setting($database);
        $module_setting = $sett_obj->get_module_setting('domain_id=' . $user_details['domain_id'] . ' and module_id=2', VIS_STAFF_ID, VIS_LOCATION_AREA);
        
        $details_txt = '<div class="form-group"><div class="col-sm-12"><label>' . $vis_language['TXTEMAIL'] . '</label><span class="link m-l-sm">' . $user_details['email'] . '</span></div></div>';
        
        if ($user_details['parent_name'] == "") {
            $details_txt .= '<div class="form-group"><div class="col-sm-12 m-t-xs"><label>' . (($operation['vis_submitter'] != 1) ? $vis_language['TXTTEAM'] : $vis_language['TXTORGANIZATION']) . '</label><span class="link m-l-sm">' . $user_details['group_name'] . '</span></div></div>';
        }
        $details_txt .= '<div class="form-group"><div class="col-sm-12 m-t-xs"><label>' . $vis_language['TXTCONTACTNUMBER'] . '</label><span class="link m-l-sm">' . $user_details['contact_number'] . '</span></div></div>';
        if ($user_details['parent_name'] != "") {
            $details_txt .= '<div class="form-group"><div class="col-sm-12 m-t-xs"><label>' . $vis_language['TXTPARENT'] . '</label><span class="link m-l-sm">' . $user_details['parent_name'] . '</span><span class="link m-l-xs">< ' . $user_details['parent_email'] . ' ></span></div></div>';
        }
        
        echo $details_txt;
    }
    //lock forum topic function 
    function lock_topic($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forum_object = new class_forum($database);
        $ret          = $forum_object->lock_topic($operation, VIS_STAFF_ID, VIS_LOCATION_AREA);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'subsetting.php');
        $sub_object = new class_subsetting($database);
        list($forumInfo, $forumTopic) = $forum_object->get_topic('topic_id=' . $operation['vis_topic_id'], $limit, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $forumTopic = $forumTopic[0];
        if (!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); </script>';
            return false;
        } else {
            $activity_title = ($forumTopic['is_lock'] == 1) ? $vis_language['TXTLOCK'] . ' topic ' : $vis_language['TXTUNLOCK'] . ' topic ';
            $activity_log   = $sub_object->add_staff_activity_log($activity_title . $forumTopic['title'], VIS_STAFF_ID,9,VIS_LOCATION_AREA);
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " ' . $vis_language['MSGSUCCOPRT'] . '");</script>';
            $lock_status = ($forumTopic['is_lock'] == 0) ? 1 : 0;
            $lock_label  = ($forumTopic['is_lock'] == 0) ? $vis_language['TXTLOCK'] : $vis_language['TXTUNLOCK'];
            $link        = '$(this).visExecution("load_operations",{"vis_module":"forums","vis_operation":"lock_topic","vis_topic_id":"' . $forumTopic['topic_id'] . '","vis_category_id":"' . $forumTopic['forum_cat_id'] . '","vis_lock_status":' . $lock_status . '})';
            echo '<script>$("#vis_lock").html(\'<a href="javascript:void(0);" onclick=' . $link . '>' . $lock_label . '</a>\');</script>';
        }
        $database->database_disconnect();
        return true;
    }
    
    function forum_list($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forumObject     = new class_forum($database);
        $spliter         = (strstr($operation['vis_action'], '/')) ? '/' : ',';
        $action          = explode($spliter, $operation['vis_action']);
        $forumCategoryId = $action[4];
        
        $filter    = VIS_TABLE_PREFIX . 'forum.forum_cat_id=' . $forumCategoryId;
        $forumData = $forumObject->get_forum($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
         for ($i = 0; $i < count($forumData); $i++) {
                $filter = VIS_TABLE_PREFIX . 'forum.forum_cat_id=' . $forumData[$i]['forum_cat_id'] . ' and ' . VIS_TABLE_PREFIX . 'forum_topic.forum_id=' . $forumData[$i]['forum_id'];
                list($forumInfo, $forumTopic) = $forumObject->get_topic($filter, '', VIS_CLIENT_ID, VIS_LOCATION_AREA);
                $forumData[$i]['topic_count']  = $forumInfo;
            }
        include(VIS_PATH_TEMPLATE . 'forum_list.php');
    }
    function update_category_order($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forumObject = new class_forum($database);
        if (isset($operation['vis_action']))
            $data = parse_form_array($operation['vis_action']);
        else
            $data = $operation;
        $filter = VIS_TABLE_PREFIX . 'forum.forum_cat_id=' . $forumCategoryId;
        $ret    = $forumObject->update_category_order($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if (!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); </script>';
            return false;
        } else {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '");
   				 $("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"forums"}); </script>';
        }
    }
    function update_forum_order($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forumObject = new class_forum($database);
        if (isset($operation['vis_action']))
            $data = parse_form_array($operation['vis_action']);
        else
            $data = $operation;
        
        $ret = $forumObject->update_forum_order($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if (!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); </script>';
            return false;
        } else {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '");
   				 $("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"forums"}); </script>';
        }
    }
    function comment_details_form($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forumObject = new class_forum($database);
        if (isset($operation['vis_action']))
            $data = parse_form_array($operation['vis_action']);
        else
            $data = $operation;
        $comment = $forumObject->get_comments(VIS_TABLE_PREFIX . 'forum_comment.comment_id = ' . $data['vis_comment_id'], $userid, $user);
        if (defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR ==0)
        $comment[0]['content'] = get_plain_text($comment[0]['content']);
        include(VIS_PATH_TEMPLATE . 'forum_comment_details.php');
    }
    function update_forum_comment($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forumObject = new class_forum($database);
        if (isset($operation['vis_action']))
            $data = parse_form_array($operation['vis_action']);
        else
            $data = $operation;
        if(defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR ==0) 
        $data['vis_forum_comment_details'.$data['vis_comment_id']] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_forum_comment_details'.$data['vis_comment_id']]);
        $ret = $forumObject->update_comment($data, $userid, $user);
        if (!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); </script>';
            return false;
        } else {
            $action = '#/forums/topic_details/' . $data['vis_topic'] . '/' . $data['vis_topic_id'];
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '"); $(\'#vis_workpanel_div\').visExecution(\'load_area\', {\'vis_module\':\'forums\', \'vis_operation\':\'topic_details\', \'vis_topic_id\':' . $data['vis_topic_id'] . ',\'vis_action\':\'' . $action . '\'}) </script>';
        }
    }
    
    
    function forum_topic_like($operation)
    {
        global $vis_language;
        if (VIS_LOCATION_AREA == 1 && !IS_LOGIN) {
            echo json_encode(array(
                'vis_submitted' => 'false'
            ));
            return false;
        }
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forumObject          = new class_forum($database);
        $forum_topic_like     = $forumObject->forum_topic_like($operation, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['message'] = (!$forum_topic_like) ? ('<div class="vis_error_message">' . $vis_language['MSGERROPRT'] . '</div>') : ('<div class="vis_message">' . $vis_language['MSGSUCCOPRT'] . '</div>');
        if ($forum_topic_like) {
            if (VIS_LOCATION_AREA != 2) {
				if($operation['comment_id']==''){
					list($forumInfo, $forumTopic) = $forumObject->get_topic('topic_id='. $operation['parent_id'], $limit, VIS_STAFF_ID, VIS_LOCATION_AREA);
					$vis_like = $forumTopic[0]['likeCount'];
				}
				else{
					$comment   	= $forumObject->get_comments('comment_id='. $operation['comment_id'], $userid, $user);
					$vis_like   = $comment[0]['like'];
				}
                $operation['vis_msg'] = $vis_language['MSGSUCCOPRT'];
                echo json_encode(array(
                    'vis_submitted' => 'true',
                    'vis_msg' => $operation['vis_msg'],
                    'like_count' => $vis_like
                ));
                
            } else {
                $action = '#/forums/topic_details/' . $operation['vis_topic'] . '/' . $operation['topic_id'];
                
                echo '<script>$(\'#vis_workpanel_div\').visExecution(\'load_area\', {\'vis_module\':\'forums\', \'vis_operation\':\'topic_details\', \'vis_topic_id\':' . $operation['topic_id'] . ',\'vis_action\':\'' . $action . '\'}) </script>';
            }
        }
        
    }
    
    function forum_topic_unlike($operation)
    {
        global $vis_language;
        if (VIS_LOCATION_AREA == 1 && !IS_LOGIN) {
            echo json_encode(array(
                'vis_submitted' => 'false'
            ));
            return false;
        }
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forumObject          = new class_forum($database);
        $forum_topic_unlike   = $forumObject->forum_topic_unlike($operation, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $operation['message'] = (!$forum_topic_unlike) ? ('<div class="vis_error_message">' . $vis_language['MSGERROPRT'] . '</div>') : ('<div class="vis_message">' . $vis_language['MSGSUCCOPRT'] . '</div>');
        if ($forum_topic_unlike) {
            if (VIS_LOCATION_AREA != 2) {
				if($operation['comment_id']==''){
					list($forumInfo, $forumTopic) = $forumObject->get_topic('topic_id='. $operation['parent_id'], $limit, VIS_STAFF_ID, VIS_LOCATION_AREA);
					$vis_like = $forumTopic[0]['likeCount'];
				}
				else{
					$comment   	= $forumObject->get_comments('comment_id='. $operation['comment_id'], $userid, $user);
					$vis_like   = $comment[0]['like'];
				}
                $operation['vis_msg'] = $vis_language['MSGSUCCOPRT'];
                echo json_encode(array(
                    'vis_submitted' => 'true',
                    'vis_msg' => $operation['vis_msg'],
                    'like_count' => $vis_like
                ));
            } else {
                $action = '#/forums/topic_details/' . $operation['vis_topic'] . '/' . $operation['topic_id'];
                echo '<script>$(\'#vis_workpanel_div\').visExecution(\'load_area\', {\'vis_module\':\'forums\', \'vis_operation\':\'topic_details\', \'vis_topic_id\':' . $operation['topic_id'] . ',\'vis_action\':\'' . $action . '\'}) </script>';
            }
        }
    }
    
    
    function get_topic_description($operation)
    {
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forum_object = new class_forum($database);
        list($forumInfo, $forumTopic) = $forum_object->get_topic('topic_id=' . $operation['vis_topic_id'], '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        $topicDescription = strip_tags($forumTopic[0]['description'], '<br><span>');
        echo substr($topicDescription, 0, 400);
    }
    function forum_likes($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forum_object = new class_forum($database);
        
        $filter         = VIS_TABLE_PREFIX . 'forum_topic_likes.parent_id = ' . $operation['vis_topic_id'] . ' and ' . VIS_TABLE_PREFIX . 'forum_topic_likes.parent_type=' . $operation['parent_type'];
        $forumTopiclike = $forum_object->get_topic_likes($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE . 'topic_likes.php');
        
    }
    // delete forum activity
    function get_delete_forum_activity($operation)
    {
        global $vis_language;
        $list_chk                       = array();
        $operation['vis_action']        = str_replace(",", "&", $operation['vis_action']);
        $message_info['vis_form_title'] = (isset($operation['vis_topic_list']) && $operation['vis_topic_list'] == 1) ? $vis_language['TXTDELETETOPIC'] : $vis_language['TXTDELETEFORUMACTIVITY'];
        $message_info['vis_message']    = $vis_language['MSGSURE'];
        $message_info['vis_event']      = "$(this).visExecution('load_operations', {'vis_module':'forums', 'vis_operation':'change_forum_activity_setting','vis_switch':'delete', 'vis_parent_id':'" . $operation['vis_parent_id'] . "', 'vis_parent_type':'" . $operation['vis_parent_type'] . "','vis_filter_id':'" . $operation['vis_filter_id'] . "','vis_action':'" . $operation['vis_action'] . "','vis_forum_id':'" . $operation['vis_forum_id'] . "'})";
        include(VIS_PATH_TEMPLATE . 'confirm_delete.php');
        return true;
    }
    function change_forum_activity_setting($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forumObject = new class_forum($database);
        $filter      = VIS_TABLE_PREFIX . 'forum_topic.forum_id = ' . $operation['vis_forum_id'];
        list($forumInfo, $topic) = $forumObject->get_topic($filter, $limit, $sort, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $topicIds = $ids = $commentIds = array();
        $list_chk = array();
        if (isset($operation['vis_parent_id']) && is_numeric($operation['vis_parent_id'])) {
            if ($operation['vis_parent_type'] == 0)
                $topicIds[] = $operation['vis_parent_id'];
            else
                $commentIds[] = $operation['vis_parent_id'];
        } else {
            $options = parse_form_array($operation['vis_action']);
            foreach ($options as $data => $value)
                if (preg_match('/vis_ticket_mass_chk_[0-9]/', $data))
                    $list_chk[] = $value;
            if ($operation['vis_form'] == "vis_topic_list_form" || $operation['vis_filter_id'] == '') {
                for ($i = 0; $i < count($list_chk); $i++) {
                    $topicIds[] = $list_chk[$i];
                }
            } else {
                for ($i = 0; $i < count($list_chk); $i++) {
                    $ids[] = explode("_", $list_chk[$i]);
                }
                for ($j = 0; $j < count($ids); $j++) {
                    if ($ids[$j][0] == 0)
                        $topicIds[] = $ids[$j][1];
                    else
                        $commentIds[] = $ids[$j][1];
                }
            }
        }
        $ret = $forumObject->change_forum_activity_setting($operation, $topicIds, $commentIds, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if (!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); </script>';
            return false;
        } else {
            $filter_id = $operation['vis_filter_id'];
            $url       = ($filter_id == 3) ? 'Waiting for approval/3' : 'Spam/4';
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '");';
            if ($operation['vis_static_area'] == 1) {
                echo '$("#vis_workpanel_div").visExecution("load_area", {"vis_module":"forums", "vis_operation":"topic_details","vis_topic_id":"' . $operation['vis_topic_id'] . '"});';
            }
           elseif ($filter_id != '') {
                echo '$("#vis_workpanel_div").visExecution("load_module","' . $url . '", {"vis_module":"forums", "vis_operation":"forum_filter","vis_action":"#/forums/forum_filter/' . $url . '"});';
            } else {
                $action = '#/forums/get_topic_list/' . $topic[0]['domain_name'] . ' : ' . $topic[0]['category_name'] . ' : ' . $topic[0]['forum_title'] . '/' . $topic[0]['forum_id'];
                echo '$("#vis_workpanel_div").visExecution("load_area", {"vis_module":"forums", "vis_operation":"get_topic_list","vis_action":"' . $action . '"});';
            }
            echo '$("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"forums"}); </script>';
        }
        $database->database_disconnect();
        return true;
    }
    // function for mark as spam to forum topic 
    function spam_topic($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forum_object = new class_forum($database);
        $ret          = $forum_object->mark_spam_topic($operation, VIS_STAFF_ID, VIS_LOCATION_AREA);
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'subsetting.php');
        $sub_object = new class_subsetting($database);
        list($forumInfo, $forumTopic) = $forum_object->get_topic('topic_id=' . $operation['vis_topic_id'], $limit, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $forumTopic = $forumTopic[0];
        if (!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGERROPRT'] . '"); </script>';
            return false;
        } else {
            $activity_title = ($forumTopic['is_spam'] == 1) ? 'Marked as spam to topic ' : 'Removed spam of topic ';
            $activity_log   = $sub_object->add_staff_activity_log($activity_title . $forumTopic['title'], VIS_STAFF_ID,9,VIS_LOCATION_AREA);
            $action       = '#/forums/topic_details/' . $topic[0]['title'] . '/' . $operation['vis_topic_id'];
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " ' . $vis_language['MSGSUCCOPRT'] . '"); $("#vis_right_panel_div").visExecution("load_area",{"vis_module":"home", "vis_operation":"load_right_panel","vis_current_module":"forums"});
            $(\'#vis_workpanel_div\').visExecution(\'load_area\', {\'vis_module\':\'forums\', \'vis_operation\':\'topic_details\', \'vis_topic_id\':' . $operation['vis_topic_id'] . ',\'vis_action\':\'' . $action . '\'})</script>';
            $spam_status = ($forumTopic['is_spam'] == 0) ? 1 : 0;
            $spam_label  = ($forumTopic['is_spam'] == 0) ? $vis_language['TXTMARKSPAM'] : $vis_language['TXTREMOVESPAM'];
            $link        = '$(this).visExecution("load_operations",{"vis_module":"forums","vis_operation":"spam_topic","vis_topic_id":"' . $forumTopic['topic_id'] . '","vis_domain_id":"' . $forumTopic['domain_id'] . '","vis_category_id":"' . $forumTopic['forum_cat_id'] . '","vis_spam_status":' . $spam_status . '})';
            echo '<script>$("#vis_spam").html(\'<a href="javascript:void(0);" onclick=' . $link . '>' . $spam_label . '</a>\');</script>';
            
        }
        $database->database_disconnect();
        return true;
    }
    function get_topic_followers($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forum_object = new class_forum($database);
        
        $filter              = VIS_TABLE_PREFIX . 'forum_topic_followers.topic_id = ' . $operation['vis_topic_id'];
        $forumTopicFollowers = $forum_object->get_topic_followers($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        
        $database->database_disconnect();
        include(VIS_PATH_TEMPLATE . 'topic_followers.php');
    }
    function get_staff_followers($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forum_object = new class_forum($database);
        
        $filter              = VIS_TABLE_PREFIX . 'forum_topic_followers.topic_id = ' . $operation['vis_topic_id'] . ' and follower_type = 0';
        $forumTopicFollowers = $forum_object->get_topic_followers($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        
        include(VIS_PATH_TEMPLATE . 'topic_staff_follower.php');
        
    }
    function add_followers($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forum_object = new class_forum($database);
        
        $forumTopicFollowers = $forum_object->add_topic_followers($operation, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if ($forumTopicFollowers) {
            if (VIS_LOCATION_AREA != 2) {
                $operation['vis_msg'] = $vis_language['MSGSUCCOPRT'];
                echo json_encode(array(
                    'vis_submitted' => 'true',
                    'vis_msg' => $operation['vis_msg']
                ));
            } else {
                echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '"); $(\'#vis_workpanel_div\').visExecution(\'load_area\', {\'vis_module\':\'forums\', \'vis_operation\':\'topic_details\', \'vis_topic_id\':' . $operation['topic_id'] . '}) </script>';
            }
        }
    }
    
    function delete_followers($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forum_object = new class_forum($database);
        if (VIS_LOCATION_AREA != 2)
            $filter = VIS_TABLE_PREFIX . 'forum_topic_followers.topic_id = ' . $operation['vis_topic_id'] . ' and follower_type = 1 and follower_id=' . VIS_CLIENT_ID;
        else
            $filter = VIS_TABLE_PREFIX . 'forum_topic_followers.topic_id = ' . $operation['vis_topic_id'] . ' and follower_type = 0 and follower_id=' . VIS_STAFF_ID;
        $forumTopicFollowers = $forum_object->delete_followers($filter, $operation['vis_topic_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if ($forumTopicFollowers) {
            if (VIS_LOCATION_AREA != 2) {
                $operation['vis_msg'] = $vis_language['MSGSUCCOPRT'];
                echo json_encode(array(
                    'vis_submitted' => 'true',
                    'vis_msg' => $operation['vis_msg']
                ));
            } else {
                $filter              = VIS_TABLE_PREFIX . 'forum_topic_followers.topic_id = ' . $operation['vis_topic_id'];
                $forumTopicFollowers = $forum_object->get_topic_followers($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
                if ($forumTopicFollowers == -1) {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '"); $("#vis_workpanel_div").visExecution("load_operations",{"vis_module":"forums", "vis_operation":"topic_details","vis_topic_id":' . $operation['vis_topic_id'] . ',"vis_action":"#/forums/topic_details/'.$operation['vis_topic_title'].'/'.$operation['vis_topic_id'].'"});  $(".modal").modal("toggle"); </script>';
                } else {
                    echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "' . $vis_language['MSGSUCCOPRT'] . '"); $(\'#ajaxModal\').visExecution(\'load_area\', {\'vis_module\':\'forums\', \'vis_operation\':\'get_topic_followers\',\'vis_currnt_operation\':\'add_followers\', \'vis_topic_id\':' . $operation['vis_topic_id'] . '});$("#vis_workpanel_div").visExecution("load_operations",{"vis_module":"forums", "vis_operation":"topic_details","vis_topic_id":' . $operation['vis_topic_id'] . ',"vis_action":"#/forums/topic_details/'.$operation['vis_topic_title'].'/'.$operation['vis_topic_id'].'"});  </script>';
                }
                
            }
        }
        
    }
    function check_is_exist($operation)
    {
        global $vis_language;
        $database = new class_database();
        include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
        $forum_object = new class_forum($database);
        $ch           = $operation['vis_switch'];
        switch ($ch) {
            case 'forum':
                $forum_category_details = $forum_object->get_forum_category('', VIS_STAFF_ID, VIS_LOCATION_AREA);
                $cnt                    = ($forum_category_details == -1) ? 0 : count($forum_category_details);
                break;
            
            case 'topic':
                $forum_details = $forum_object->get_forum('', VIS_STAFF_ID, VIS_LOCATION_AREA);
                $cnt           = ($forum_details == -1) ? 0 : count($forum_details);
                break;
        }
        echo json_encode(array(
            'cnt' => $cnt
        ));
    }
	
	function unfollow_all($operation){
		global $vis_language;
		$header_title = $vis_language['TXTFORUMSETTINGS'];
		$breadcrumb['Home'] = 'index.php'; 
		$breadcrumb[$vis_language['TXTFORUMSETTINGS']] = '';
		$vis_title = $vis_language['TXTFORUMSETTINGS'];
		if(isset($operation['unfollowall']) && $operation['unfollowall'] == 1){
			include(VIS_PATH_TEMPLATE . 'unfollow_all.php');
			return true;
		}
		
	}	
    function delete_all_followers($operation){
		global $vis_language;
		$database = new class_database();
       include_once(VIS_PATH_CLASS . VIS_CLASS_PREFIX . 'forum.php');
       $forum_object = new class_forum($database);
	   $ret = $forum_object->delete_all_followers(VIS_CLIENT_ID, VIS_LOCATION_AREA);
	   if($ret){
		   echo json_encode(array(
                    'vis_submitted' => 'true',
                    'vis_msg' => $operation['vis_msg']
                ));
	   }
		
	}	
}
?>

